unit Unit1;

//  ,    
//     (    
//    F : file of TProduct ).  ,
//       . 

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, StrUtils;

type
  TForm1 = class(TForm)
    CbBoxCategory: TComboBox;
    EditName: TEdit;
    CbBoxDistrib: TComboBox;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    EditPrice: TEdit;
    Label9: TLabel;
    Label10: TLabel;
    Button1: TButton;
    CbBoxProduser: TComboBox;
    Button2: TButton;
    Memo1: TMemo;
    ChBoxCategory: TCheckBox;
    ChBoxProduser: TCheckBox;
    ChBoxDistrib: TCheckBox;
    Label1: TLabel;
    Bevel1: TBevel;
    Label2: TLabel;
    Bevel2: TBevel;
    Label3: TLabel;
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
    procedure EditPriceChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;


  //   
  TProduct = record
     Category : integer;     //  (ItemIndex)
     Produser : integer;     //  (ItemIndex)
     Name     : string[32];  // 
     Price    : double;      // 
     Distrib  : integer;     //  (ItemIndex)
   end;

var
  Form1    : TForm1;

var
  OpenFlag : boolean;        //  -   
  Product  : TProduct;       //  
  f : file of TProduct;      //    

implementation

{$R *.DFM}

//    
procedure LoadCbBox (RqBox : TComboBox; FileName : string);
begin
  try
    RqBox.Items.LoadFromFile(FileName);
  except
    RqBox.Clear;
    ShowMessage('   : ' + FileName);
  end;
  if RqBox.Items.Count = 0 then RqBox.Items.Add(' ');
  RqBox.ItemIndex := 0
end;

//        
function ProStrToFloat (RqStr   : string;
                    var RqFloat : double) : boolean;
begin
  Result  := False;     //   
  try
    RqFloat := StrToFloat(RqStr);
    Result  := True;    //   
  except
    ShowMessage('    ');
  end;
end;

//     
procedure TForm1.EditPriceChange(Sender: TObject);
var WDbl : double;
begin
 if EditPrice.Text <> ''
 then  if ProStrToFloat(EditPrice.Text, WDbl)
       then Product.Price := WDbl;
end;

//   
function GreateDataFile (RqFileName : string) : boolean;
begin
  Result := False;       //   
  AssignFile(f, RqFileName);
  {$I-}
  Rewrite(f);
  {$I+}
  if IOResult = 0
  then begin
     Result := True;   //     
     CloseFile( f );   //  
  end
  else ShowMessage('   .');
end;

//    
function VerifyDataFile (RqFileName : string) : boolean;
var URep : word;       //   
begin
  Result := False;     //   
  if not FileExists(RqFileName)
  then begin
     URep := MessageDlg('    .'+
                       '  ?',
                       mtInformation,[mbYes,mbNo],0);
     if URep = mrYes
     then Result := GreateDataFile (RqFileName);
  end
  else Result := True;
end;

//      - 
function OpenFDb (RqFileName : string) : boolean;
begin

  Result := False;       //   
  if VerifyDataFile (RqFileName)
  then begin
    AssignFile(f, RqFileName);
    {$I-}
    //     fmOpenRead = $0002 (Read/Write)
    Reset(f);
    {$I+}
    if IOResult = 0
    then Result := True //   
    else begin
        MessageDlg('   : '+ RqFileName,
                    mtError,[mbYes],0);
        Halt;
    end;
  end;
end;

//  
procedure TForm1.FormActivate(Sender: TObject);
begin
  if OpenFDb ('.\FDb\product.fb1')
  then Button1.Enabled := True;
end;

//      
procedure TForm1.Button1Click(Sender: TObject);
var URep : word;       //   
begin
  {$I-}
  //     
  Seek( f, FileSize(f));
  {$I+}
  if IOResult = 0
  then begin
    with Product do
    begin
       //   
       Category := CbBoxCategory.ItemIndex;
       Produser := CbBoxProduser.ItemIndex;
       Name := EditName.Text;
       Distrib := CbBoxDistrib.ItemIndex;
    end;
    URep := MessageDlg('      ?',
                       mtConfirmation,[mbYes,mbNo],0);
    if URep = mrYes
    then Write(f, Product); //     
  end;
end;

//       
function Selector (RqChBox : TCheckBox;
                   RqCbBox : TComboBox;
                   Ind     : integer) : boolean;
begin
  Result := True;
  if RqChBox.Checked
  then begin
     Result := False;
     if RqCbBox.ItemIndex = Ind then Result := True;
  end;
end;

//      
procedure TForm1.Button2Click(Sender: TObject);
var SCat, SProd, SDist : boolean;
    Num : word;
begin
   Num := 0;
   Memo1.Clear;
   {$I-}
   Seek( f, 0);
   {$I+}
   if IOResult = 0
   then begin
      while not EOF(f)
      do begin
          //   
          Read(f, Product);
          //   
          SCat  := Selector(ChBoxCategory, CbBoxCategory, Product.Category);
          SProd := Selector(ChBoxProduser, CbBoxProduser, Product.Produser);
          SDist := Selector(ChBoxDistrib,  CbBoxDistrib,  Product.Distrib);
          //   
          if SCat and SProd and SDist  //  
          then begin
             Num := Num + 1;
             Memo1.Lines.Add( '  ' + IntToStr(Num)+ ' ' + DupeString('-',80));
             Memo1.Lines.Add(' : '
                            + CbBoxCategory.Items[Product.Category]);
             Memo1.Lines.Add('. : ' + Product.Name);
             Memo1.Lines.Add('. : '
                            + CbBoxProduser.Items[Product.Produser]);
             Memo1.Lines.Add(' : ' + FloatToStr(Product.Price));
             Memo1.Lines.Add(' : '
                            + CbBoxDistrib.Items[Product.Distrib]);
          end;
      end;
   end;
end;


//     
procedure TForm1.FormCreate(Sender: TObject);
begin
   LoadCbBox (CbBoxCategory, '.\Boxes\Category.txt');
   LoadCbBox (CbBoxProduser, '.\Boxes\Produser.txt');
   LoadCbBox (CbBoxDistrib,  '.\Boxes\Distrib.txt');
end;

//   
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     CloseFile( f );  //  
end;

end.
